/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.IVWSIMScenario;
import filenet.sim.api.IVWSIMSimulation;
import filenet.sim.api.VWSIMScenario;
import filenet.sim.api.VWSIMSimulation;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.appserver.IVWSIMCommand;
import filenet.sim.appserver.VWSIMCommand;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMFactoryProperties;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import simulator.publisher.VWSIMPAQueryResult;
import simulator.publisher.VWSIMPublishedSimulation;
import simulator.publisher.VWSIMQueryToken;
import simulator.util.VWSIMException;

public class VWSIMSession {
    private final String m_className = "VWSIMSession";
    private IVWIDMFactory m_idmfactory = VWIDMBaseFactory.instance();
    private String m_token = null;
    private String m_soapUrl = null;
    protected IVWSIMCommand vwsimCommandInterface = null;
    private static Logger logger = Logger.getLogger("filenet.sim.api");

    public VWSIMSession() throws VWException {
        IVWIDMFactoryProperties props = this.m_idmfactory.getProperties();
        String baseUrl = (String)props.getProperty("baseURL");
        if (baseUrl == null) {
            throw new VWException("sim.api.VWSIMSession.NullWebServerBaseUrl", "Cannot find web server base url from the logon");
        }
        this.m_soapUrl = baseUrl + "vwsimsoapservlet";
        this.m_token = (String)props.getProperty("token");
        this.vwsimCommandInterface = new VWSIMCommand(this.m_soapUrl, this.m_token);
    }

    public IVWSIMScenario getScenario(String libraryId, String scenarioDocId) throws VWException {
        if (libraryId == null) {
            throw new VWException("sim.api.VWSIMSession.NullLibraryId", "No library id specified");
        }
        if (scenarioDocId == null) {
            throw new VWException("sim.api.VWSIMSession.NullDocId", "No document id specified");
        }
        VWSIMScenario scenario = null;
        if (this.m_idmfactory != null) {
            IVWIDMDocument idmDocument = this.m_idmfactory.getIDMDocument(libraryId, null, scenarioDocId);
            scenario = new VWSIMScenario(idmDocument);
        }
        return scenario;
    }

    public IVWSIMSimulation getSimulation(String libraryId, String simulationDocId) throws VWException {
        if (libraryId == null) {
            throw new VWException("sim.api.VWSIMSession.NullLibraryId", "No library id specified");
        }
        if (simulationDocId == null) {
            throw new VWException("sim.api.VWSIMSession.NullDocId", "No document id specified");
        }
        VWSIMSimulation simulation = null;
        if (this.m_idmfactory != null) {
            IVWIDMDocument idmDocument = this.m_idmfactory.getIDMDocument(libraryId, null, simulationDocId);
            simulation = new VWSIMSimulation(idmDocument, this.vwsimCommandInterface);
        }
        return simulation;
    }

    public IVWSIMSimulation createSimulation(String simulationName, String simulationDescription, String system, int region, IVWSIMScenario scenario, String libraryId, String simDocId) throws VWException {
        String m_method = "createSimulation";
        IVWIDMDocument document = null;
        Object currentVersion = null;
        VWSIMSimulation simulation = null;
        Object simGuid = null;
        IVWIDMFactory idmFactory = VWIDMBaseFactory.instance();
        if (idmFactory != null) {
            VWScenarioDefinition scenarioDefinition = null;
            byte[] docContents = null;
            IVWIDMLibrary library = this.m_idmfactory.getIDMLibrary(libraryId);
            document = library.getDocument(simDocId);
            docContents = document.checkoutNoUI();
            ByteArrayInputStream is = new ByteArrayInputStream(docContents);
            scenarioDefinition = VWScenarioDefinition.read(is);
            Boolean oPublishingEnabled = (Boolean)document.getProp("PublishingEnabled");
            if (oPublishingEnabled != null) {
                scenarioDefinition.setCollectAnalysisData(oPublishingEnabled);
            }
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            scenarioDefinition.write(outStream);
            byte[] fileContents = outStream.toByteArray();
            try {
                outStream.close();
            }
            catch (Exception e) {
                throw new VWException("sim.api.VWSIMSession.ErrorWhenCloseScenarioDefinitionStream", "Error when close scenario definition stream");
            }
            document.checkin(null, fileContents, false, simulationName, null);
        }
        simulation = new VWSIMSimulation(system, region, simulationName, document, this.vwsimCommandInterface);
        logger.info("VWSIMSession", m_method, "Simulation object created on client.");
        return simulation;
    }

    public IVWSIMSimulation createSimulation(String simulationName, String simulationDescription, String system, int region, String scenarioDocId, String libraryId, String simDocId) throws VWException {
        IVWSIMScenario scn = this.getScenario(libraryId, scenarioDocId);
        return this.createSimulation(simulationName, simulationDescription, system, region, scn, libraryId, simDocId);
    }

    public VWSIMPAQueryResult getPAQueryResult(String userName, int maxRecords) throws VWException {
        if (maxRecords == 0) {
            logger.info("VWSIMSession", "getPAQueryResult", "request 0 number of query reuslt, just return null");
            return null;
        }
        byte[] bytesResult = null;
        try {
            bytesResult = this.vwsimCommandInterface.getPublishedSimulations(userName, null, maxRecords);
        }
        catch (VWSIMException e) {
            logger.severe("VWSIMSession", "getPAQueryResult", e.getMessage());
            throw e;
        }
        catch (VWException e) {
            logger.throwing("VWSIMSession", "getPAQueryResult", e);
            throw e;
        }
        catch (Exception e) {
            throw new VWException("sim.api.VWSIMSession.FailGetPublsiheSimulationsQuery", "Fail to query published simulations, {0}", e.getMessage());
        }
        if (bytesResult == null) {
            logger.info("VWSIMSession", "getPublishedSimulations", "bytes returned for query is null");
            return null;
        }
        VWSIMPAQueryResult result = this.fromBytes(bytesResult);
        return result;
    }

    public VWSIMPAQueryResult getNextPAQueryResult(VWSIMQueryToken token, int maxRecords) throws VWException {
        if (maxRecords == 0) {
            logger.info("VWSIMSession", "getNextPAQueryResult", "request 0 number of query reuslt, just return null");
            return null;
        }
        if (token == null) {
            throw new VWException("sim.api.VWSIMSession.NullTokenForQuery", "The token for the ''get next'' PA query is null");
        }
        byte[] bytesResult = null;
        byte[] bytesToken = this.toBytes(token);
        if (bytesToken == null) {
            throw new VWException("sim.api.VWSIMSession.NullTokenBytes", "bytes for token is null.");
        }
        try {
            bytesResult = this.vwsimCommandInterface.getPublishedSimulations(null, bytesToken, maxRecords);
        }
        catch (VWSIMException e) {
            logger.severe("VWSIMSession", "getNextPAQueryResult", e.getMessage());
            throw e;
        }
        catch (VWException e) {
            logger.throwing("VWSIMSession", "getNextPAQueryResult", e);
            throw e;
        }
        catch (Exception e) {
            throw new VWException("sim.api.VWSIMSession.FailGetPublsiheSimulationsQuery", "Fail to query published simulations, {0}", e.getMessage());
        }
        if (bytesResult == null) {
            logger.info("VWSIMSession", "getPublishedSimulations", "bytes returned for query is null");
            return null;
        }
        VWSIMPAQueryResult result = this.fromBytes(bytesResult);
        return result;
    }

    public void deletePublishedData(VWSIMPublishedSimulation[] sims) throws VWException {
        if (sims == null) {
            logger.severe("VWSIMSession", "deletePublishedData", "Delete null published data");
            throw new VWException("sim.api.VWSIMSession.NullPublishedData", "Null published data for deleting");
        }
        if (sims.length == 0) {
            logger.info("VWSIMSession", "deletePublishedData", "0 number of elements for published simulations array");
            return;
        }
        byte[] basims = this.toBytes(sims);
        try {
            this.vwsimCommandInterface.deletePublishedData(basims);
        }
        catch (VWSIMException e) {
            logger.severe("VWSIMSession", "deletePublishedData", e.getMessage());
            throw e;
        }
        catch (VWException e) {
            logger.throwing("VWSIMSession", "deletePublishedData", e);
            throw e;
        }
        catch (Exception e) {
            throw new VWException("sim.api.VWSIMSession.FailDeletePublishedData", "Fail to delete published data, {0}", e.getMessage());
        }
    }

    private byte[] toBytes(Object obj) throws VWException {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objOs = new ObjectOutputStream(new BufferedOutputStream(byteStream));
            objOs.flush();
            objOs.writeObject(obj);
            objOs.flush();
            byte[] sendBuf = byteStream.toByteArray();
            objOs.close();
            return sendBuf;
        }
        catch (IOException ioe) {
            throw new VWException("sim.api.VWSIMSession.ToBytesError", "Error while serializing an object.");
        }
    }

    private VWSIMPAQueryResult fromBytes(byte[] bytesResult) throws VWException {
        VWSIMPAQueryResult result = null;
        try {
            ByteArrayInputStream bi = new ByteArrayInputStream(bytesResult);
            ObjectInputStream is = new ObjectInputStream(bi);
            result = (VWSIMPAQueryResult)is.readObject();
            is.close();
            bi.close();
        }
        catch (ClassNotFoundException cx) {
            logger.severe(this.getClass().getName(), "fromBytes", "Unexpected input data type.  Expecting VWSIMPAQueryResult.");
            throw new VWException("sim.api.VWSIMSession.UnexpectedInputDataType", "Unexpected input data type. {0}", cx.getMessage());
        }
        catch (ClassCastException cx) {
            logger.severe(this.getClass().getName(), "fromBytes", "Unexpected input data type.  Expecting VWSIMPAQueryResult.");
            throw new VWException("sim.api.VWSIMSession.UnexpectedInputDataType", "Unexpected input data type. {0}", cx.getMessage());
        }
        catch (IOException iox) {
            logger.severe(this.getClass().getName(), "fromBytes", "Unable to read input data.");
            throw new VWException("sim.api.VWSIMSession.UnableReadInputData", "Unable to read input data. {0}", iox.getMessage());
        }
        return result;
    }

    public IVWSIMScenario createScenarioFromIdmDocument(IVWIDMDocument document) {
        return new VWSIMScenario(document);
    }

    public IVWSIMSimulation createSimulationFromIdmDocument(IVWIDMDocument document) throws VWException {
        return new VWSIMSimulation(document, this.vwsimCommandInterface);
    }
}

